% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_logical.R
\name{check_zero_value}
\alias{check_zero_value}
\title{Identify records with zero-valued measurement data}
\usage{
check_zero_value(data, return_df = FALSE)
}
\arguments{
\item{data}{A data frame. Must contain a column named \code{value}.}

\item{return_df}{Logical. If TRUE, return a plain data.frame of problematic rows
instead of a DT datatable. Default = FALSE.}
}
\value{
A DT datatable or a data.frame of zero-value records, or \code{NULL} (invisibly)
if no zero values are found.
}
\description{
This function scans a dataset for cases where the measurement column (\code{value})
contains zero (0) values, which may indicate missing, censored, or erroneous data.
It returns either a \code{DT::datatable} for easy inspection or a plain \code{data.frame} of
the affected rows. This function is useful for quality control and validation
prior to data aggregation, reporting, or database submission.
}
\examples{
# Example dataset
df <- data.frame(
  station_name = c("A", "B", "C", "D"),
  sample_date = as.Date(c("2023-06-01", "2023-06-02", "2023-06-03", "2023-06-04")),
  value = c(3.2, 0, 1.5, 0)
)

# Return a plain data.frame of zero-value records
check_zero_value(df, return_df = TRUE)

}
