% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensionScripts.R
\name{sampleMarginalFit}
\alias{sampleMarginalFit}
\title{Sample from the marginal distribution of the target variable}
\usage{
sampleMarginalFit(fitX, sampleY, medianY, yCP, xMed, dist = "best",
  link = "identity")
}
\arguments{
\item{fitX}{an object of class \code{elicitation} specifying the
c-distribution: the distribution of the target variable, conditional on the
extension variable taking its median value.}

\item{sampleY}{a sample from the marginal distribution of the extension 
variable.}

\item{medianY}{the median value of the extension variable.}

\item{yCP}{vector of conditioning points for the extension variable.}

\item{xMed}{vector of medians of the target variable, corresponding to
each value of the extension variable in \code{yCP}.}

\item{dist}{choice of parametric distribution for the c-distribution. Options are
\code{"normal"}, \code{"t"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, \code{"hist"} (for a histogram fit), and
\code{"best"} (for best fitting).}

\item{link}{link in the median function. One of \code{"identity"},
\code{"log"} or \code{"logit"}}
}
\value{
a vector containing a sample from the marginal distribution of 
the target variable.
}
\description{
As part of the Extension Method, this function will generate a random 
sample from the marginal distribution of the target variable, using
a sample from the marginal distribution of the extension variable, 
the specified c-distribution, and the appropriate judgements used to
construct the median model.
}
\examples{
\dontrun{

myfitX <- fitdist(vals = c(5.5, 9, 14),
 probs = c(0.25, 0.5, 0.75),
 lower = 0)
ry <- rgamma(10, 5.19, 0.694)
sampleMarginalFit(fitX = myfitX, 
 sampleY = ry,
 medianY = 7,
 yCP = c(3, 5, 7, 9.5, 13.5),
 xMed = c(2, 6.5, 9, 13, 20),
 dist = "lognormal",
 link = "log")
 }
}
