% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getBv}
\alias{getBv}
\alias{getQueenBv}
\alias{getFathersBv}
\alias{getVirginQueensBv}
\alias{getWorkersBv}
\alias{getDronesBv}
\title{Access breeding values of individuals in a caste}
\usage{
getBv(x, caste = NULL, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getQueenBv(x, collapse = FALSE, simParamBee = NULL)

getFathersBv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getVirginQueensBv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getWorkersBv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getDronesBv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link{Pop-class}},
and character when \code{x} is a \code{\link{Colony-class}} or
 \code{\link{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{collapse}{logical, if the return value should be a single matrix
with breeding valued of all the individuals}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
vector of breeding values when \code{x} is \code{\link{Colony-class}}
  and list of vectors of breeding values when \code{x} is
  \code{\link{MultiColony-class}}, named by colony id when \code{x} is
  \code{\link{MultiColony-class}}

# Not exporting this function, since the theory behind it is not fully developed
}
\description{
Level 0 function that returns breeding values of individuals in
  a caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenBv()}: Access breeding value of the queen

\item \code{getFathersBv()}: Access breeding values of fathers

\item \code{getVirginQueensBv()}: Access breeding values of virgin queens

\item \code{getWorkersBv()}: Access breeding values of workers

\item \code{getDronesBv()}: Access breeding values of drones

}}
\seealso{
\code{\link{bv}} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
