% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{isWorkersPresent}
\alias{isWorkersPresent}
\alias{areWorkersPresent}
\alias{areDronesPresent}
\title{Are workers present}
\usage{
isWorkersPresent(x, simParamBee = NULL)

areWorkersPresent(x, simParamBee = NULL)

areDronesPresent(x, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
logical, named by colony id when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 function that returns workers presence status (are they
  present or not).
}
\section{Functions}{
\itemize{
\item \code{areWorkersPresent()}: Are workers present

\item \code{areDronesPresent()}: Are drones present

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 120, nDrones = 20)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 100, nDrones = 10)

isWorkersPresent(colony)
isWorkersPresent(removeWorkers(colony))
isWorkersPresent(apiary)
isWorkersPresent(removeWorkers(apiary))
}
