% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sitcor.R
\name{sitcor}
\alias{sitcor}
\alias{sit}
\title{Conduct the sliced independence test.}
\usage{
sitcor(
  x,
  y = NULL,
  c = 2,
  pvalue = FALSE,
  ties = FALSE,
  method = "asymptotic",
  nperm = 199,
  factor = FALSE
)
}
\arguments{
\item{x}{Vector of numeric values in the first coordinate.}

\item{y}{Vector of numeric values in the second coordinate.}

\item{c}{The number of observations in each slice.}

\item{pvalue}{Whether or not to return the p-value of rejecting
independence, if TRUE the function also returns the standard deviation of
sit.}

\item{ties}{Do we need to handle ties? If ties=TRUE the algorithm assumes
that the data has ties and employs the more elaborated theory for
calculating s.d. and P-value. Otherwise, it uses the simpler theory. There
is no harm in putting ties = TRUE even if there are no ties.}

\item{method}{If method = "asymptotic" the function returns P-values
computed by the asymptotic theory (not available in the presence of ties). If method = "permutation", a permutation
test with nperm permutations is employed to estimate the P-value. Usually,
there is no need for the permutation test. The asymptotic theory is good
enough.}

\item{nperm}{In the case of a permutation test, \code{nperm} is the number
of permutations to do.}

\item{factor}{Whether to transform integers into factors, the default is to
leave them alone.}
}
\value{
In the case pvalue=FALSE, function returns the value of the sit
coefficient, if the input is a matrix, a matrix of coefficients is returned.
In the case pvalue=TRUE is chosen, the function returns a list:
\describe{\item{sitcor}{The
value of the sit coefficient.}
\item{sd}{The standard deviation.}
\item{pval}{The test p-value.}
}
}
\description{
This function computes the sit coefficient between two vectors x and y,
possibly all paired coefficients for a matrix.
}
\examples{

##---- Should be DIRECTLY executable !! ----
library("psychTools")
data(peas)
# Visualize       the peas data
library(ggplot2)
ggplot(peas,aes(parent,child)) +
geom_count() + scale_radius(range=c(0,5)) +
       xlim(c(13.5,24))+ylim(c(13.5,24))+       coord_fixed() +
       theme(legend.position="bottom")
# Compute one of the coefficients
sitcor(peas$parent,peas$child, c = 4, pvalue=TRUE)
sitcor(peas$child,peas$parent, c = 4)
# Compute all the coefficients
sitcor(peas, c = 4)

}
\references{
Zhang Y., Chen C., & Zhu L. (2022). Sliced Independence Test. Statistica Sinica. https://doi.org/10.5705/ss.202021.0203.
}
\author{
Yilin Zhang, Canyi Chen & Liping Zhu
}
\keyword{~htest}
\keyword{~methods}
