% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequencing.R
\name{randomSingleCells}
\alias{randomSingleCells}
\title{Simulate single cell sequencing data}
\usage{
randomSingleCells(tumor, ncells, fpr = 0, fnr = 0)
}
\arguments{
\item{tumor}{A list which is the output of \code{\link{simulateTumor}()}.}

\item{ncells}{The number of cells to sample.}

\item{fpr}{The false positive rate}

\item{fnr}{The false negative rate}
}
\value{
A data frame with sample names on the row and mutation ID on the column. 
A 1 indicates that the mutation is present in the cell and a 0 indicates the mutation is not present.
}
\description{
Simulate single cell sequencing data by random selecting cells from the tumor.
}
\details{
The procedure is exactly the same as \code{\link{singleCell}()} except that it allows multiple cells
to be sequenced at once (chosen randomly throughout the entire tumor).
}
\examples{
out <- simulateTumor(N = 1000)
df <- randomSingleCells(tumor = out, ncells = 5, fnr = 0.1) 
}
\author{
Phillip B. Nicol <philnicol740@gmail.com>
}
