% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectedseries.R
\name{SelectedSeries}
\alias{SelectedSeries}
\title{Identified the Series with the Given Order}
\usage{
SelectedSeries(M, order = c(1, 0, 1))
}
\arguments{
\item{M}{Matrix that is an output from "SummaryModel" command, that is, M1, M2 or M3.}

\item{order}{Specification of the non-seasonal part of the ARIMA model:
the three integer components \eqn{(p,d,q)} are \eqn{p} the AR order, \eqn{d} the degree of differencing,
and \eqn{q} the MA order. Default value is c(1, 0, 1).}
}
\value{
The number of series with the given order and the names of the resulting series.
}
\description{
To be used after the command "SummaryModel". The input "M" must be an output from "SummaryModel".
Selected time series of a given order \eqn{(p,d,q)}.
}
\examples{
data(TaiwanAirBox032017)
outputSummaryModel <- SummaryModel(TaiwanAirBox032017[,1:3])
SelectedSeries(outputSummaryModel$M1, order = c(2,0,0))

}
