% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLOPE.R
\name{SLOPE}
\alias{SLOPE}
\title{SLOPE: Sorted L1 Penalized Estimation}
\usage{
SLOPE(X, y, fdr = 0.2, lambda = "gaussian", sigma = NULL,
  normalize = TRUE, solver = c("default", "matlab"), ...)
}
\arguments{
\item{X}{the \eqn{n}-by-\eqn{p} design matrix}

\item{y}{response vector of length \eqn{n}}

\item{fdr}{target FDR (false discovery rate)}

\item{lambda}{specifcation of \eqn{\lambda}, either one of "bhq" or "gaussian",
or a vector of length \eqn{p}, sorted in decreasing order
(see \code{\link{create_lambda}})}

\item{sigma}{noise level. If omitted, estimated from the data (see Details).}

\item{normalize}{whether to center the input data and re-scale the columns
of the design matrix to have unit norm. Do not disable this unless you are
certain that your data is appropriately pre-processed.}

\item{solver}{which SLOPE solver to use (see Details)}

\item{...}{additional arguments to pass to the solver (see the relevant
solver)}
}
\value{
An object of class \code{SLOPE.result}. This object is a list
 containing at least the following components:
 \item{lambda}{the \eqn{\lambda} sequence used}
 \item{lambda_method}{method of \eqn{\lambda} construction
  ("bhq", "gaussian", or "user")}
 \item{sigma}{(sequence of) noise level(s) used}
 \item{beta}{optimized coefficient vector \eqn{\beta}}
 \item{selected}{selected variables
   (variables \eqn{i} with \eqn{\beta_i > 0})}
}
\description{
Performs variable selection using SLOPE (Sorted L1 Penalized Estimation).
Given a design matrix \eqn{X} and a response vector \eqn{y}, find the
coefficient vector \eqn{\beta} minimizing
\deqn{\frac{1}{2} \Vert X\beta - y \Vert_2^2 +
      \sigma \cdot \sum_{i=1}^p \lambda_i |\beta|_{(i)},}
where the \eqn{\lambda} sequence is chosen to control the false discovery
rate associated with nonzero components of \eqn{\beta}.
}
\details{
At present, two solvers for the SLOPE problem are supported. By
default, we use \code{\link{SLOPE_solver}}, which is mostly written in R but
uses a fast prox implemented in C. If you have MATLAB installed, it is also
possible to use the TFOCS solver for SLOPE. This requires the MATLAB package
TFOCS and the R package \code{R.matlab}.

If the noise level is unknown, it is estimated from the data using one of
two methods. When \eqn{n} is large enough compared to \eqn{p}, the classical
unbiased estimate of \eqn{\sigma^2} is used. Otherwise, the
\emph{iterative SLOPE} algorithm is used, in which a decreasing sequence of
\eqn{\sigma^2} estimates is used until the set of selected variables
stabilizes. For details, see Section 3.2.3 of the SLOPE paper.
}
\seealso{
\code{\link{SLOPE_solver}}
}

