% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.smle}
\alias{predict.smle}
\alias{predict.selection}
\title{Prediction based on SMLE screening and selection}
\usage{
\method{predict}{smle}(object, newdata = NULL, ...)

\method{predict}{selection}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{A fitted object of class \code{'smle'} as the output from
SMLE.}

\item{newdata}{Matrix of new values for the features at which predictions are to be made using the final model 
from SMLE() or smle_select(). If omitted, the function returns the fitted 
response values based on the data.}

\item{...}{Further arguments passed to \code{predict.glm()}.}
}
\value{
A prediction vector. The length of the vector equals to the number of observations of the data fitted in.
}
\description{
This function returns predicted response values for a fitted model of class \code{'smle'} or \code{'selection'}.
}
\examples{

Data_sim<-Gen_Data(n= 200, p =1000, correlation="AR",family = "gaussian", num_ctgidx =5)
fit<-SMLE(Data_sim$Y,Data_sim$X, family = "gaussian" , k=10)
predict(fit,newdata= Data_sim$X[10:20,])
Selection <- smle_select(fit)
predict(Selection)




}
