\name{generatepriors}
\alias{generatepriors}
\title{
A function to create pseudodata for \code{snpmclust} algorithm
}
\description{
\code{generatepriors} creates bivariate normal pseudodata for the homozygous and heterozygous minor genotypes.
}
\usage{
generatepriors(x, y, calls, priorpoints = length(x) * 0.2, 
               xm1 = NA, xm2 = NA, xm3 = NA, 
               ym1 = NA, ym2 = NA, ym3 = NA, ranseed = ranseed)
}
\arguments{
  \item{x}{
x-vector of signal intensity data in transformed scale.
}
  \item{y}{
y-vector of signal intensity data in transformed scale.
}
  \item{calls}{
A priori genotype calls for intensity data.
}
  \item{priorpoints}{
The number of observations of pseudodata to be generated for the heterozygous and homozygous minor genotypes.
}
  \item{xm1, xm2, xm3, ym1, ym2, ym3}{
Pseudodata cluster means can be user-specified through these parameters.  The ordered pair (xm1,ym1) gives the cluster mean for genotype AA; similarly for (xm2,ym2), (xm3,ym3) and AB, BB, respectively.  Default values are NA, in which case cluster means are estimated from the data, conditional on the a priori genotypes passed via calls.
}
  \item{ranseed}{
Random seed for generation of pseudodata.  The default is 1969.
}
}
\value{
A priorpoints-by-2 matrix.
}
\author{
Stephen W. Erickson, PhD \email{SErickson@uams.edu}
with Joshua Callaway, MPH \email{jcallaw3@utk.edu}
}
\keyword{ priors }
\keyword{ pseudodata }
