% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateSpaceFilling.R
\name{phi_p}
\alias{phi_p}
\alias{mindist}
\title{Functions to evaluate space filling of an array}
\usage{
phi_p(D, dmethod = "manhattan", p = 50)

mindist(D, dmethod = "manhattan")
}
\arguments{
\item{D}{an array or an object of class SOA or MDLE}

\item{dmethod}{the distance to use, \code{"manhattan"} (default) or \code{"euclidean"}}

\item{p}{the value for p to use in the formula for phi_p}
}
\value{
both functions return a number
}
\description{
phi_p calculates the discrepancy
}
\details{
Small values of phi_p tend to be associated with good performance on the
maximin distance criterion, i.e. with a larger minimum distance.
}
\examples{
A <- DoE.base::L25.5.6  ## levels 1:5 for each factor
phi_p(A)
mindist(A) # 5
A2 <- phi_optimize(A)
phi_p(A2)     ## improved
mindist(A2)   ## 6, improved
}
\author{
Ulrike Groemping
}
