% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contr.Power.R
\name{contr.Power}
\alias{contr.Power}
\title{A contrast function based on regular factorials
for number of levels a prime or prime power}
\usage{
contr.Power(n, s = 2, contrasts = TRUE)
}
\arguments{
\item{n}{integer or vector; either an integer number of levels of the factor for
which contrasts are created, which must be a a power of \code{s}; or a factor
whose number of levels is a power of \code{s}; or a vector of levels whose
number of elements is a power of \code{s}.}

\item{s}{integer; prime or prime power}

\item{contrasts}{logical; must be TRUE}
}
\value{
\code{contr.Power} yields a matrix of contrasts. It can be used in
function \code{model.matrix} or anywhere where factors with the number of
levels a power of $s$ are used with contrasts. The exponent for \code{x}
is determined from the number of levels.
}
\description{
A contrast function based on regular factorials
for number of levels a prime or prime power
}
\details{
The function is a generalization (with slowest first instead of fastest first)
of function \code{contr.FrF2} from package \pkg{DoE.base}. It is in this
package because it needs Galois field functionality from package \pkg{lhs}
for non-prime \code{s}.
}
\examples{
## the same n can yield different contrasts for different s
contr.Power(16, 2)
contr.Power(16, 4)

}
\references{
Groemping (2022b)
}
