% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSOAs.R
\name{OSOAs}
\alias{OSOAs}
\title{Function to create an OSOA from an OA}
\usage{
OSOAs(
  oa,
  el = 3,
  m = NULL,
  noptim.rounds = 1,
  noptim.repeats = 1,
  optimize = TRUE,
  dmethod = "manhattan",
  p = 50
)
}
\arguments{
\item{oa}{matrix or data.frame that contains an ingoing symmetric OA. Levels must be denoted as 0 to s-1 or as 1 to s.}

\item{el}{the exponent of the number of levels, \code{el=3} yields a
strength 2* OSOA in s^3 levels, \code{el=2} a strength 2+ OSOA in s^2 levels}

\item{m}{the desired number of columns of the resulting array; odd values of
m will be reduced by one, so specify the next largest even m, if you need an
odd number of columns (the function will do so, if possible; if \code{m=NULL},
the maximum possible value is used.}

\item{noptim.rounds}{the number of optimization rounds for each independent restart}

\item{noptim.repeats}{the number of independent restarts of optimizations with \code{noptim.rounds} rounds each}

\item{optimize}{logical: should space filling be optimized by level permutations?}

\item{dmethod}{distance method for \code{\link{phi_p}}, "manhattan" (default) or "euclidean"}

\item{p}{p for \code{\link{phi_p}} (the larger, the closer to maximin distance)}
}
\value{
matrix of class \code{SOA} with the attributes that are listed below. All attributes can be accessed using function \code{\link{attributes}}, or individual attributes can be accessed using function \code{\link{attr}}. These are the attributes:
\describe{
\item{type}{the type of array (\code{SOA} or \code{OSOA})}
\item{strength}{character string that gives the strength}
\item{phi_p}{the phi_p value (smaller=better)}
\item{optimized}{logical indicating whether optimization was applied}
\item{permpick}{matrix that lists the id numbers of the permutations used}
\item{perms2pickfrom}{optional element, when optimization was conducted: the
overall permutation list to which the numbers in permlist refer}
\item{call}{the call that created the object}
}
}
\description{
An OSOA in ns runs of strength 2* (s^3 levels) or 2+ (s^2 levels) is created from an OA(n,m,s,2).
}
\details{
The function implements the algorithms proposed by Zhou and Tang 2018
(s^2 levels) or Li, Liu and Yang 2021 (s^3 levels).
Both are enhanced with the modification for matrix A by Groemping 2022.
Level permutations are optimized
using an adaptation of the algorithm by Weng (2014).

Suitable OAs for argument \code{oa} can e.g. be constructed with OA creation functions
from package \pkg{lhs} or can be obtained
from arrays listed in R package \pkg{DoE.base}
}
\examples{
## run with optimization for actual use!

## 54 runs with seven 9-level columns
OSOAs(DoE.base::L18[,3:8], el=2, optimize=FALSE)

## 54 runs with six 27-level columns
OSOAs(DoE.base::L18[,3:8], el=3, optimize=FALSE)

## 81 runs with four 9-level columns
OSOAs(DoE.base::L27.3.4, el=2, optimize=FALSE)
## An OA with 9-level factors (L81.9.10)
## has complete balance in 2D,
## however does not achieve 3D projection for
## all four collapsed triples
## It is up to the user to decide what is more important.
## I would go for the OA.

## 81 runs with four 27-level columns
OSOAs(DoE.base::L27.3.4, el=3, optimize=FALSE)
}
\references{
For full detail, see \code{\link{SOAs-package}}.

Groemping (2022a)\cr
Li, Liu and Yang (2021)\cr
Weng (2014)\cr
Zhou and Tang (2019)\cr
}
\author{
Ulrike Groemping
}
