% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateSpaceFilling.R, R/utilitiesEvaluate.R
\name{phi_p}
\alias{phi_p}
\alias{mindist}
\title{Functions to evaluate space filling of an array}
\usage{
phi_p(D, dmethod = "manhattan", p = 50)

mindist(D, dmethod = "manhattan")

phi_p(D, dmethod = "manhattan", p = 50)
}
\arguments{
\item{D}{an array or an object of class SOA or MDLE}

\item{dmethod}{the distance to use, \code{"manhattan"} (default) or \code{"euclidean"}}

\item{p}{the value for p to use in the formula for phi_p}
}
\value{
both functions return a number

a number
}
\description{
phi_p calculates the discrepancy

phi_p calculates the discrepancy
}
\details{
Small values of phi_p tend to be associated with good performance on the
maximin distance criterion, i.e. with a larger minimum distance.

small values of phi_p are associated with good performance on the
maximin distance criterion
}
\examples{
A <- DoE.base::L25.5.6  ## levels 1:5 for each factor
phi_p(A)
mindist(A) # 5
A2 <- phi_optimize(A)
phi_p(A2)     ## improved
mindist(A2)   ## 6, improved
A <- DoE.base::L16.4.5  ## levels 1:4 for each factor
phi_p(A)
phi_p(A, dmethod="euclidean")
A2 <- A
A2[,4] <- c(2,4,3,1)[A[,4]]
phi_p(A2)
\dontrun{
  ## A2 has fewer minimal distances
  par(mfrow=c(2,1))
  hist(dist(A), xlim=c(2,6), ylim=c(0,40))
  hist(dist(A2), xlim=c(2,6), ylim=c(0,40))
}
}
\author{
Ulrike Groemping

Ulrike Groemping
}
