% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCtaxa_tab.R
\name{DCtaxa_tab}
\alias{DCtaxa_tab}
\title{DCtaxa_tab}
\usage{
DCtaxa_tab(qvaltab, groupvar, alpha)
}
\arguments{
\item{qvaltab}{A table with adjusted p-values (or q-value in this package).}

\item{groupvar}{Specify the name of binary indicator variable.}

\item{alpha}{A level of significance (e.g. 0.05).}
}
\value{
q-values and names of significantly DC taxa (e.g. taxa name) based on SOHPIE_DNA function.
}
\description{
A function to obtain a list consisting of taxa that are significantly differentially connected (DC)
between two biological or clinical conditions. These DC taxa are resulted from the pseudo-value regression method with
additional covariates. In addition, a user can extract the names of DC taxa only.
}
\examples{
\donttest{
data(combinedamgut) # A complete data containing columns with taxa and clinical covariates.

# Note: The line below will use a toy example with the first 30 out of 138 taxa.
OTUtab = combinedamgut[ , 8:37]
# Clinical/demographic covariates (phenotypic data):
# Note: All of these covariates will be included in the regression, so
# please make sure that phenodat includes the variables that will be analyzed only.
phenodat = combinedamgut[, 1:7] # first column is ID, so not using it.
# Obtain indices of each grouping factor
# In this example, a variable indicating the status of living with a dog was chosen (i.e. bin_dog).
# Accordingly, Groups A and B imply living without and with a dog, respectively.
 newindex_grpA = which(combinedamgut$bin_dog == 0)
 newindex_grpB = which(combinedamgut$bin_dog == 1)

SOHPIEres <- SOHPIE_DNA(OTUdat = OTUtab, clindat = phenodat,
groupA = newindex_grpA, groupB = newindex_grpB)

# Create an object to keep the table with q-values using qval() function.
qvaltab <- qval(SOHPIEres)

# Please do NOT forget to provide the name of variable in DCtaxa_tab(groupvar = ).
DCtaxa_tab <- DCtaxa_tab(qvaltab = qvaltab, groupvar = "bin_dog", alpha = 0.3)
DCtaxa_tab
}
}
