% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HexaHitsQuant.R
\name{HexaHitsQuant}
\alias{HexaHitsQuant}
\title{Hits distribution on the SOM map}
\usage{
HexaHitsQuant(hits, Coord, Row, Col)
}
\arguments{
\item{hits}{Vector with number of hits for each prototype}

\item{Coord}{Prototype coordinates for plotting the map}

\item{Row}{Number of SOM map rows}

\item{Col}{Number of SOM map columns}
}
\value{
Plot a SOM map with hits represented as grayscale according to quartiles
}
\description{
Plot a SOM map with hits plotted as grayscale according to quartiles
}
\details{
The function plots a SOM map with hits represented as grayscale according to quartiles,
from white (lower outliers) followed by grayscale (quartiles) and black (upper outiliers).
The prototype with the maximum number of hits is represented by a red hexagon.
The outilers and quartiles are evaluated by boxplot function applying default parameters.
}
\references{
{Licen, S., Cozzutto, S., Barbieri, P. (2020) Aerosol Air Qual. Res., 20 (4), pp. 800-809. DOI: 10.4209/aaqr.2019.08.0414
}
}
\seealso{
boxplot
}
\author{
Sabina Licen
}
