% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hexagons.R
\name{Hexagons}
\alias{Hexagons}
\title{Function to draw an hexagonal SOM map}
\usage{
Hexagons(Coords, Row, Col, color = NA, border = "gray", unitcell = 1)
}
\arguments{
\item{Coords}{matrix containing the x and y coordinates of the hexagon centers}

\item{Row}{Number of SOM map rows}

\item{Col}{Number of SOM map columns}

\item{color}{Filling color of the hexagons (default NA)}

\item{border}{Border color of the hexagons (default "gray")}

\item{unitcell}{The distance side to side between two parallel sides of the hexagon (default 1)}
}
\value{
A hexagonal SOM map
}
\description{
Draws an hexagonal SOM map using x, y coordinates for the hexagon centers
}
\examples{
Coord<-CodeCoord(10,5)
Hexagons(Coord,10,5)
}
\references{
{Licen, S., Cozzutto, S., Barbieri, P. (2020) Aerosol Air Qual. Res., 20 (4), pp. 800-809. DOI: 10.4209/aaqr.2019.08.0414
}
}
\author{
Sabina Licen
}
