% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSaggreg.R
\name{TSaggreg}
\alias{TSaggreg}
\title{Aggregates daily rainfall totals at quasi-week time scales}
\usage{
TSaggreg(daily.rain, start.date, TS = 4L)
}
\arguments{
\item{daily.rain}{Vector, 1-column matrix or data frame with daily rainfall totals.}

\item{start.date}{Date at which the aggregation should start. Preferred formats are
\dQuote{YYYY-MM-DD}, \dQuote{YYYY/MM/DD} but most any valid date format
should work.}

\item{TS}{Time scale on the quasiWeek basis (integer values between 1 and 96).
Default is 4, which corresponds to the monthly time scale.}
}
\value{
A matrix with rainfall amounts aggregated at the time scale selected by
the user
}
\description{
Aggregates daily rainfall totals at quasi-week time scales
}
\examples{

daily.rain <- CampinasRain[,2]
rainTS4 <- TSaggreg(daily.rain=daily.rain,start.date="1980-01-01",TS=4)
}
