% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot.R
\name{spotStepRunAlg}
\alias{spotStepRunAlg}
\title{SPOT Step Algorithm Call}
\usage{
spotStepRunAlg(spotConfig, ...)
}
\arguments{
\item{spotConfig}{the list of all configuration parameters, but most important ones are:\cr 
\code{spotConfig$alg.func} the name of the R target function \cr
\code{spotConfig$io.apdFileName} filename for the problem definition of the algorithm, 
          first parameter of the generically defined R-function spotConfig$alg.func \cr
\code{spotConfig$io.desFileName} filename for the input of the algorithm, 
          second parameter of the generically defined R-function spotConfig$alg.func \cr
\code{spotConfig$io.resFileName} filename for the output of the algorithm
          third parameter of the generically defined R-function spotConfig$alg.func\cr
\code{spotConfig$io.verbosity} verbosity for command window output, which is passed to the output function}

\item{...}{additional parameters to be passed on to target function which is called inside alg.func}
}
\description{
This is the second SPOT Step after step "initial" - but also needed 
after each step "sequential", and is a call frame for the algorithm-call.
}
\details{
The algorithm is the heart of what the user must provide, but SPOT should be 
able to handle them in the most flexible manner. This function is an interface to the algorithm,
given as a R-function.
}
\seealso{
\code{\link{SPOT}} \code{\link{spot}} \code{\link{spotStepInitial}}
\code{\link{spotStepSequential}}
}

