% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasMnist.R
\name{funKerasMnist}
\alias{funKerasMnist}
\title{funKerasMnist}
\usage{
funKerasMnist(x, kConf = getKerasConf(), data = getMnistData())
}
\arguments{
\item{x}{matrix of hyperparameter values to evaluate with the function.
Rows for points and columns for dimension.}

\item{kConf}{List of additional parameters passed to keras as described in \code{\link{getKerasConf}}.
Default: \code{kConf = getKerasConf()}.}

\item{data}{mnist data set. Default: \code{\link{getMnistData}}.}
}
\value{
1-column matrix with resulting function values (test loss)
}
\description{
Hyperparameter Tuning: Keras MNIST Classification Test Function.
}
\details{
Trains a simple deep NN on the MNIST dataset.
Provides a template that can be used for other networks as well.
Standard Code from https://keras.rstudio.com/
Modified by T. Bartz-Beielstein (tbb@bartzundbartz.de)
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE = FALSE
if(PYTHON_RETICULATE){

library("SPOTMisc")
library("SPOT")
kerasConf <- getKerasConf()
lower <- c(1e-6, 1e-6, 16,0.6, 1e-9, 10, 6,0.4,0.99,1,1e-8)
upper <- c(0.5, 0.5, 512, 1.5, 1e-2, 50, 10,0.999,0.999,10,6e-8)
types <- c("numeric",  "numeric",  "integer",  "numeric",  "numeric",
           "integer",  "integer",  "numeric",  "numeric",  "integer",
           "numeric")

### First example: simple function call:
x <- matrix(lower, 1,)
funKerasMnist(x, kConf = kerasConf)

### Second example: evaluation of several (three) hyperparameter settings:
xxx <- rbind(x,x,x)
funKerasMnist(xxx, kConf = kerasConf)

### Third example: spot call with extended verbosity:
kerasConf$verbose <- 1
res <- spot(x = NULL,
            fun = funKerasMnist,
            lower = lower,
            upper = upper,
            control = list(funEvals=50,
                         noise = TRUE,
                         types = types,
                         plots = TRUE,
                         progress = TRUE,
                         seedFun = 1,
                         seedSPOT = 1),
                         kConf = kerasConf)
  }
}

}
\seealso{
\code{\link{getKerasConf}}

\code{\link{evalKerasMnist}}

\code{\link[keras]{fit}}
}
