% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportSensitivityAnalysis.R
\name{sequentialBifurcation}
\alias{sequentialBifurcation}
\title{Sequential Bifurcation}
\usage{
sequentialBifurcation(
  fun,
  lower,
  upper,
  k,
  interaction = FALSE,
  verbosity = 0,
  ...
)
}
\arguments{
\item{fun}{function}

\item{lower}{bound of natural variables. Determines the number of parameters (variables).}

\item{upper}{bound of natural variables}

\item{k}{\code{integer}  bifurcations. Must be smaller than the number of parameters.}

\item{interaction}{\code{logical} TRUE if two-factor interactions should be considered. Default is
\code{FALSE}.}

\item{verbosity}{\code{integer}. If larger than zero, the designs are shown.}

\item{...}{optional parameters passed to fun}
}
\value{
sa \code{list} with sensitivity information (effects) for subgroups.
}
\description{
\code{sequentialBifurcation} is a wrapper function to
\code{\link[sensitivity]{sb}} from the \code{\link{sensitivity}} package.
}
\details{
The model without interaction is
 \code{Y = beta_0 + sum_{i=1}^p beta_i X_i},
 while the model with two-factor interactions is
 \code{Y = beta_0 + sum_{i=1}^p beta_i X_i + sum_{1 <= i < j <= p} gamma_{ij} X_i X_j}.
 In both cases, the factors are assumed to be uniformly distributed on [-1,1].
 This is a difference with Bettonvil et al. where the factors vary across [0,1] in the former case, while [-1,1] in the latter.
 Another difference with Bettonvil et al. is that in the current implementation, the groups are splitted right in the middle.
}
\references{
B. Bettonvil and J. P. C. Kleijnen, 1996,
Searching for important factors in simulation models with many factors:
sequential bifurcations,
European Journal of Operational Research, 96, 180–194.
}
