% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPlot.R
\name{plot_surface}
\alias{plot_surface}
\title{Surface plot of a model}
\usage{
plot_surface(
  object,
  which = if (ncol(object$x) > 1 & tolower(type) != "singledim") {
     1:2
 } else {
   
     1
 },
  constant = object$x[which.min(unlist(object$y)), ],
  xlab = paste("x", which, sep = ""),
  ylab = "y",
  type = "filled.contour",
  ...
)
}
\arguments{
\item{object}{the result list returned by \code{\link[SPOT]{spot}}, importantly including a \code{modelFit}, and the data \code{x}, \code{y}.}

\item{which}{a vector with two elements, each an integer giving the two independent variables of the plot
(the integers are indices of the respective data set).}

\item{constant}{a numeric vector that states for each variable a constant value that it will take on
if it is not varied in the plot. This affects the parameters not selected by the \code{which} parameter.
By default, this will be fixed to the best known solution, i.e., the one with minimal y-value, according
to \code{which.min(object$y)}. The length of this numeric vector should be the same as the number of columns in \code{object$x}}

\item{xlab}{a vector of characters, giving the labels for each of the two independent variables.}

\item{ylab}{character, the value of the dependent variable predicted by the corresponding model.}

\item{type}{string describing the type of the plot:  \code{"filled.contour"} (default), \code{"contour"},
\code{"persp"} (perspective), or \code{"persp3d"} plot.
Note that "persp3d" is based on the plotly package and will work in RStudio, but not in the standard RGui.}

\item{...}{additional parameters passed to the \code{contour} or \code{filled.contour} function.}
}
\value{
plotly visualization (based on \code{\link[plotly]{plot_ly}})
}
\description{
A (filled) contour or perspective plot of a fitted model.
}
