% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures.R
\name{plotTaxonomy}
\alias{plotTaxonomy}
\title{Barplot of the most abundant taxa in a SQM object}
\usage{
plotTaxonomy(
  SQM,
  rank = "phylum",
  count = "percent",
  N = 15,
  tax = NULL,
  others = TRUE,
  samples = NULL,
  nocds = "treat_separately",
  ignore_unmapped = FALSE,
  ignore_unclassified = FALSE,
  no_partial_classifications = FALSE,
  rescale = FALSE,
  color = NULL,
  base_size = 11,
  max_scale_value = NULL,
  metadata_groups = NULL
)
}
\arguments{
\item{SQM}{A SQM or a SQMlite object.}

\item{rank}{Taxonomic rank to plot (default \code{phylum}).}

\item{count}{character. Either \code{"percent"} for percentages, or \code{"abund"} for raw abundances (default \code{"percent"}).}

\item{N}{integer Plot the \code{N} most abundant taxa (default \code{15}).}

\item{tax}{character. Custom taxa to plot. If provided, it will override \code{N} (default \code{NULL}).}

\item{others}{logical. Collapse the abundances of least abundant taxa, and include the result in the plot (default \code{TRUE}).}

\item{samples}{character. Character vector with the names of the samples to include in the plot. Can also be used to plot the samples in a custom order. If not provided, all samples will be plotted (default \code{NULL}).}

\item{nocds}{character. Either \code{"treat_separately"} to treat reads annotated as No CDS separately, \code{"treat_as_unclassified"} to treat them as Unclassified or \code{"ignore"} to ignore them in the plot (default \code{"treat_separately"}).}

\item{ignore_unmapped}{logical. Don't include unmapped reads in the plot (default \code{FALSE}).}

\item{ignore_unclassified}{logical. Don't include unclassified reads in the plot (default \code{FALSE}).}

\item{no_partial_classifications}{logical. Treat reads not fully classified at the requested level (e.g. "Unclassified bacteroidetes" at the class level or below) as fully unclassified. This takes effect before \code{ignore_unclassified}, so if both are \code{TRUE} the plot will only contain fully classified contigs (default \code{FALSE}).}

\item{rescale}{logical. Re-scale results to percentages (default \code{FALSE}).}

\item{color}{Vector with custom colors for the different features. If empty, we will use our own hand-picked pallete if N<=15, and the default ggplot2 palette otherwise (default \code{NULL}).}

\item{base_size}{numeric. Base font size (default \code{11}).}

\item{max_scale_value}{numeric. Maximum value to include in the y axis. By default it is handled automatically by ggplot2 (default \code{NULL}).}

\item{metadata_groups}{list. Split the plot into groups defined by the user: list('G1' = c('sample1', sample2'), 'G2' = c('sample3', 'sample4')) default \code{NULL}).}
}
\value{
a ggplot2 plot object.
}
\description{
This function selects the most abundant taxa across all samples in a SQM object and represents their abundances in a barplot. Alternatively, a custom set of taxa can be represented.
}
\examples{
data(Hadza)
Hadza.amin = subsetFun(Hadza, "Amino acid metabolism")
# Taxonomic distribution of amino acid metabolism ORFs at the family level.
plotTaxonomy(Hadza.amin, "family")
}
\seealso{
\code{\link{plotFunctions}} for plotting the most abundant functions of a SQM object; \code{\link{plotBars}} and \code{\link{plotHeatmap}} for plotting barplots or heatmaps with arbitrary data.
}
