% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TV_initialization.R
\name{TV_initialization}
\alias{TV_initialization}
\title{TV norm dictionary initialization}
\usage{
TV_initialization(
  Data,
  K,
  cutoff = 0.5,
  Npattern = 8,
  set_size = ncol(Data),
  DoCopies = FALSE,
  ncores = 4,
  DIR_tmp = tempdir()
)
}
\arguments{
\item{Data}{is a Filebacked Big Matrix \eqn{s \times N} with data vectors stored in the matrix columns.}

\item{K}{is a dictionary size.}

\item{cutoff}{is a cut off value, the default value is 0.5.}

\item{Npattern}{is a number of patterns selected in the dataset to create the dictionary}

\item{set_size}{is a maximum size of the set of possible patterns.}

\item{DoCopies}{indicates whether to duplicate patterns.}

\item{ncores}{is a number of cores}

\item{DIR_tmp}{is a directory to save temporary files}
}
\value{
a dictionary matrix
}
\description{
Dictionary initialization using a TV norm criterion
}
\details{
The dictionary is initialized by extracting and duplicating patterns with the highest TV norm values
To limit the set of possible patterns, only signals with the correlation less then a fixed threshold \code{cutoff} are
taken into account. If the set of possible patterns is too large, it can be further reduced by taking only
\code{set_size} less correlated patterns. The implemented initialization routine can only be applied to positive value data.
}
\examples{
X = matrix(abs(rnorm(n = 1000)), ncol = 100, nrow = 10)
X_fbm = bigstatsr::FBM(init = X, ncol = ncol(X), nrow = nrow(X))
D0 = TV_initialization(X_fbm, K = 20, Npattern = 5, DoCopies = TRUE, ncores = 1)
}
