% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCNearestMeanClassifier.R
\name{MCNearestMeanClassifierSSLR}
\alias{MCNearestMeanClassifierSSLR}
\title{General Interface for MCNearestMeanClassifier (Moment Constrained Semi-supervised Nearest Mean Classifier) model}
\usage{
MCNearestMeanClassifierSSLR(
  update_sigma = FALSE,
  prior = NULL,
  x_center = FALSE,
  scale = FALSE
)
}
\arguments{
\item{update_sigma}{logical; Whether the estimate of the variance should be updated
after the means have been updated using the unlabeled data}

\item{prior}{matrix; Class priors for the classes}

\item{x_center}{logical;  Should the features be centered?}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}
}
\description{
model from RSSL package
Update the means based on the moment constraints as defined in Loog (2010).
The means estimated using the labeled data are updated by making sure their
weighted mean corresponds to the overall mean on all (labeled and unlabeled) data.
Optionally, the estimated variance of the classes can be re-estimated after this
update is applied by setting update_sigma to \code{TRUE}. To get the true nearest mean
classifier, rather than estimate the class priors, set them to equal priors using, for
instance \code{prior=matrix(0.5,2)}.
}
\examples{
library(tidyverse)
library(caret)
library(tidymodels)
library(SSLR)

data(breast)

set.seed(1)
train.index <- createDataPartition(breast$Class, p = .7, list = FALSE)
train <- breast[ train.index,]
test  <- breast[-train.index,]

cls <- which(colnames(breast) == "Class")

#\% LABELED
labeled.index <- createDataPartition(breast$Class, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- MCNearestMeanClassifierSSLR() \%>\% fit(Class ~ ., data = train)

#Accesing model from RSSL
model <- m$model

#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Class", estimate = .pred_class)
}
\references{
Loog, M., 2010. Constrained Parameter Estimation for
Semi-Supervised Learning: The Case of the Nearest Mean Classifier.
In Proceedings of the 2010 European Conference on Machine
learning and Knowledge Discovery in Databases. pp. 291-304.
}
