% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R, R/predict_glm.R
\name{predict.SSN2}
\alias{predict.SSN2}
\alias{predict.ssn_lm}
\alias{predict.ssn_glm}
\title{Model predictions (Kriging)}
\usage{
\method{predict}{ssn_lm}(
  object,
  newdata,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  block = FALSE,
  ...
)

\method{predict}{ssn_glm}(
  object,
  newdata,
  type = c("link", "response"),
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  newdata_size,
  level = 0.95,
  var_correct = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{newdata}{A character vector that indicates the name of the prediction data set
in the SSN object for which predictions are desired. If omitted, predictions
for all prediction data sets are returned. Note that the name \code{".missing"}
indicates the prediction data set that contains the missing observations in the data used
to fit the model.}

\item{se.fit}{A logical indicating if standard errors are returned.
The default is \code{FALSE}.}

\item{interval}{Type of interval calculation. The default is \code{"none"}.
Other options are \code{"confidence"} (for confidence intervals) and
\code{"prediction"} (for prediction intervals).}

\item{level}{Tolerance/confidence level. The default is \code{0.95}.}

\item{block}{A logical indicating whether a block prediction over the entire
region in \code{newdata} should be returned. The default is \code{FALSE}, which returns point
predictions for each location in \code{newdata}. Currently only available for
model fit using \code{ssn_lm()} or models fit using \code{ssn_glm()} where
\code{family} is \code{"gaussian"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{type}{The scale (\code{response} or \code{link}) of predictions obtained
using \code{ssn_glm} objects.}

\item{newdata_size}{The \code{size} value for each observation in \code{newdata}
used when predicting for the binomial family.}

\item{var_correct}{A logical indicating whether to return the corrected prediction
variances when predicting via models fit using \code{ssn_glm}. The default is
\code{TRUE}.}
}
\value{
If \code{se.fit} is \code{FALSE}, \code{predict.ssn()} returns
a vector of predictions or a matrix of predictions with column names
\code{fit}, \code{lwr}, and \code{upr} if \code{interval} is \code{"confidence"}
or \code{"prediction"}. If \code{se.fit} is \code{TRUE}, a list with the following components is returned:
\itemize{
\item \code{fit}: vector or matrix as above
\item \code{se.fit:} standard error of each fit
}
}
\description{
Predicted values and intervals based on a fitted model object.
}
\details{
The (empirical) best linear unbiased predictions (i.e., Kriging
predictions) at each site are returned when \code{interval} is \code{"none"}
or \code{"prediction"} alongside standard errors. Prediction intervals
are also returned if \code{interval} is \code{"prediction"}. When
\code{interval} is \code{"confidence"}, the estimated mean is returned
alongside standard errors and confidence intervals for the mean.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, predpts = "pred1km", overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
predict(ssn_mod, "pred1km")
}
