% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STR_analysis.R
\name{STR_analysis}
\alias{STR_analysis}
\title{Analysis of short tandem repeats (STRs) in a given region of any reference genome}
\usage{
STR_analysis(seqName, nr.STRs = 10, nr.mismatch = 0, chrs, STR = "A",
  lens.grey = 0:5 * 1000, start.position = NA, end.position = NA,
  reverse.comp = FALSE, bed_file, pos_matrix, output_file,
  species = BSgenome.Hsapiens.UCSC.hg19::Hsapiens,
  dsb_map = STRAH::dsb_map)
}
\arguments{
\item{seqName}{A character string which is the name of the given sequence file under study. Can also be set to "" in order to analyze a defined sequence from any reference genome such as the package BSgenome.Hsapiens.UCSC.hg19 for humans.}

\item{nr.STRs}{An integer value reflecting the minimum length of STRs to be searched for.}

\item{nr.mismatch}{An integer value reflecting the allowed number of mismatches of the short tandem repeats. By default it set to 0.}

\item{chrs}{A string reflecting the chromosome under study (starting with "chr" and adding either the integers from 1-22 or "X" respectively "Y" for the human genome). This argument can also be a vector of strings to study several chromosomes.}

\item{STR}{A character string for the nucleotide to be searched for. By default one searches for poly-As, hence set to "A".}

\item{lens.grey}{An integer value which is by default a vector of 6 integer values. These values represent the greyzones to be studied left and right from the hotspot regions.}

\item{start.position}{An integer value reflecting the start position of the region to be analyzed. If set to \code{NA} the analysis starts from the beginning of the chromosome.}

\item{end.position}{An integer value reflecting the end position of the region to be analyzed. If set to \code{NA} the analysis is performed until the end of the chromosome.}

\item{reverse.comp}{A logical value by default \code{FALSE}. If set to \code{TRUE} then the reverse complement of the sequence is analyzed.}

\item{bed_file}{A bed file containing the chromosomes, start, and end positions of the region(s) that should be analyzed.}

\item{pos_matrix}{A matrix or dataframe containing the chromosomes, start, and end positions of the region(s) that should be analyzed.}

\item{output_file}{The default is an empty string and does not save an output-file. The output will be saved if the parameter is changed to a user defined string excluding the extension (by default .bed).}

\item{species}{The human genome (version 19) is default but an alternative genome can be provided. For chimpanzees the parameter has to be BSgenome.Ptroglodytes.UCSC.panTro5 (given that the data is installed).}

\item{dsb_map}{The DSB map of the human genome (version 19) is default but an alternative DSB map from a different genome can be provided. This parameter needs to be a data frame with at least 3 columns that contains the chromosome, start, and end position of the DSB. The DSB map for chimpanzees is included in the package.}
}
\value{
The output of the function is a list with the following content:
\item{Sequence Name}{The chromosome with the starting and end position of the region under study is provided.}
\item{Reverse Complement}{An indicator whether the reverse complement was considered}
\item{Number of allowed Mismatches}{The number of allowed mismatches is provided.}
\item{Minimum Length}{The minimum length of the STR to be extracted is provided.}
\item{Number of Matches}{The total number of STR matches of the region is provided.}
\item{Length of STR stretch in bp}{A vector containing the length of STRs per match is provided.}
\item{Start positions}{The starting positions of the STRs are provided.}
\item{Zone}{The zones where the STR is found are provided. 1 reflects within a hotspot, the last integer reflects that it is outside, and the integers between these two reflect the given flanking regions starting with 2 as the next closest region to the hotspot.}

A BED file with the chromosomes, start, and end position of the STRs, length of the STR stretch, the zone where the STR was found, and the specified region that was analyzed are given as columns.
}
\description{
This function separates detected short tandem repeats (STRs) into different zones. These zones are either the hotspot zone defined by the double strand break maps of Pratto et al. (2014) or adjacent flanking zones (greyzones) left and right of the hotspots of user specified lengths. The parameters of the regions under study can be directly given in the function arguments or read in via either a BED-file or a position matrix.
}
\examples{
data(chr6_1580213_1582559)
STR_analysis(seqName = chr6_1580213_1582559, nr.STRs = 10, nr.mismatch = 0, chrs = "chr6",
STR = "A", lens.grey = 0:1*100, start.position = 1580213, end.position = 1582559,
reverse.comp = FALSE,
species = BSgenome.Hsapiens.UCSC.hg19::Hsapiens, dsb_map = STRAH::dsb_map)
\donttest{
STR_analysis(nr.STRs = 10, nr.mismatch = 0, chrs = "chr22", STR = "A", lens.grey = 0:1*100,
start.position = 30000000, end.position = 31000000, reverse.comp = FALSE,
species = BSgenome.Hsapiens.UCSC.hg19::Hsapiens, dsb_map = STRAH::dsb_map)
# If you want to use the function with a different reference genome
# make your choice and install it before:
if(requireNamespace("BSgenome.Ptroglodytes.UCSC.panTro5")) {
STR_analysis(nr.STRs = 10, nr.mismatch = 0, chrs = "chr22", STR = "A", lens.grey = 0:5*1000,
start.position = 30000000, end.position = 31000000, reverse.comp = FALSE,
species = BSgenome.Ptroglodytes.UCSC.panTro5::BSgenome.Ptroglodytes.UCSC.panTro5,
dsb_map = STRAH::dsb_map_chimp_full)
}
}
}
\references{
Heissl, A., et al. (2018) Length asymmetry and heterozygosity strongly influences the evolution of poly-A microsatellites at meiotic recombination hotspots. doi: https://doi.org/10.1101/431841

Pratto, F., et al. (2014). Recombination initiation maps of individual human genomes. Science, 346(6211).

Kuhn RM, et al. (2013) The UCSC genome browser and associated tools, Brief. Bioinform., 14, 144-161.
}
\seealso{
\code{\link{getflank2}}, \code{\link{STR_detection}}
}
\author{
Philipp Hermann, \email{philipp.hermann@jku.at}, Monika Heinzl, \email{monika.heinzl@edumail.at}
Angelika Heissl, Irene Tiemann-Boege, Andreas Futschik
}
\keyword{array}
\keyword{datasets}
\keyword{list}
\keyword{methods}
\keyword{univar}
