% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projINLA.R
\name{projINLA}
\alias{projINLA}
\title{Function to obtain projected estimates from INLA for each time and region.}
\usage{
projINLA(data, inla_mod, years, geo, newyear = "15-19", quantiles = c(0.025,
  0.5, 0.975))
}
\arguments{
\item{data}{country summary data from \code{\link{countrySummary_mult}}}

\item{inla_mod}{output from \code{\link{fitINLA}}}

\item{years}{years string vector}

\item{geo}{geographic polygon object}

\item{newyear}{string of years for projection, defaults to \code{'15-19'}}

\item{quantiles}{quantiles desired, defaults to \code{c(0.025,0.5,0.975)}}
}
\value{
Results from RW2 model fit, including projection.
}
\description{
Function to obtain projected estimates from INLA for each time and region.
}
\examples{
\dontrun{
data(Uganda)
data(UgandaMap)
geo <- UgandaMap$geo
mat <- UgandaMap$Amat
years <- c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14")

# Get direct estimates
u5m <- countrySummary_mult(births = Uganda, years = years, idVar = "id", 
regionVar = "region", timeVar = "time", clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", geo.recode = NULL)

# Get hyper priors
priors <- simhyper(R = 2, nsamp = 1e+05, nsamp.check = 5000, Amat = mat)

# Fit INLA models
data <- data[data$region \%in\% c("central","eastern","northern","western"),]
inla_model <- fitINLA(data = data, geo = geo, Amat = mat, year_names = years, priors = priors)

# Projection
surveylabel <- paste0("DHS ", unique(data$surveyYears)) 
results_rw2 <- projINLA(data = data, inla_mod = inla_model, years = years, geo = geo, 
                     newyear = "15-19", quantiles = c(0.025,0.5,0.975))
}


}
