% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapPlot.R
\name{mapPlot}
\alias{mapPlot}
\title{Makes map plot.}
\usage{
mapPlot(data, variables, values = NULL, labels = NULL, geo, by.data,
  by.geo, is.long = FALSE, size = 0.5, removetab = FALSE,
  border = "gray20", ncol = NULL, ylim = NULL)
}
\arguments{
\item{data}{a data frame with variables to be plotted}

\item{variables}{vector of variables to be plotted. If long format of data is used, only one variable can be selected}

\item{values}{the column corresponding to the values to be plotted, only used when long format of data is used}

\item{labels}{vector of labels to use for each variable, only used when wide format of data is used}

\item{geo}{\code{geo} output from \code{\link{read_shape}}}

\item{by.data}{column name specifying region names in the data}

\item{by.geo}{variable name specifying region names in the data}

\item{is.long}{logical indicator of whether the data is in the long format, default to FALSE}

\item{size}{size of the border}

\item{removetab}{logical indicator to not show the tab label, only applicable when only one tab is present.}

\item{border}{color of the border}

\item{ncol}{number of columns for the output tabs}

\item{ylim}{range of the values to be plotted.}
}
\description{
This function visualizes the map with different variables. The input data frame can be either the long or wide format.
}
\examples{
\dontrun{
data(DemoMap)
# Plotting data in the long format
dat <- data.frame(region = rep(c("central",  "eastern", "northern", "western"), 3),
year = rep(c(1980, 1990, 2000), each = 4),
values = stats::rnorm(12))
utils::head(dat)
mapPlot(dat, variables = "year", values = "values",
by.data = "region", geo = DemoMap$geo,
by.geo = "NAME_final", is.long = TRUE)
dat <- data.frame(region = c("central",  "eastern", "northern", "western"),
Year1 = stats::rnorm(4), Year2 = stats::rnorm(4),
Year3 = stats::rnorm(4))
utils::head(dat)
mapPlot(dat, variables = c("Year1", "Year2", "Year3"),
 labels = c(1980, 1990, 2000),
by.data = "region", geo = DemoMap$geo,
by.geo = "NAME_final", is.long = FALSE)

}

}
