% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitINLA2.R
\name{smoothCluster}
\alias{smoothCluster}
\alias{fitINLA2}
\title{Cluster-level space-time smoothing models for mortality rates}
\usage{
smoothCluster(data, family = c("betabinomial", "binomial")[1],
  age.groups = c("0", "1-11", "12-23", "24-35", "36-47", "48-59"),
  age.n = c(1, 11, 12, 12, 12, 12), age.rw.group = c(1, 2, 3, 3, 3, 3),
  time.model = c("rw1", "rw2", "ar1")[2], st.time.model = NULL, Amat,
  bias.adj = NULL, bias.adj.by = NULL, formula = NULL, year_label,
  type.st = 4, survey.effect = FALSE, strata.time.effect = FALSE,
  hyper = c("pc", "gamma")[1], pc.u = 1, pc.alpha = 0.01,
  pc.u.phi = 0.5, pc.alpha.phi = 2/3, pc.u.cor = 0.7,
  pc.alpha.cor = 0.9, pc.st.u = NA, pc.st.alpha = NA,
  pc.st.slope.u = NA, pc.st.slope.alpha = NA, overdisp.mean = 0,
  overdisp.prec = 0.4, options = list(config = TRUE),
  control.inla = list(strategy = "adaptive", int.strategy = "auto"),
  verbose = FALSE, geo = NULL, rw = NULL, ar = NULL,
  st.rw = NULL, ...)

fitINLA2(data, family = c("betabinomial", "binomial")[1],
  age.groups = c("0", "1-11", "12-23", "24-35", "36-47", "48-59"),
  age.n = c(1, 11, 12, 12, 12, 12), age.rw.group = c(1, 2, 3, 3, 3, 3),
  time.model = c("rw1", "rw2", "ar1")[2], st.time.model = NULL, Amat,
  bias.adj = NULL, bias.adj.by = NULL, formula = NULL, year_label,
  type.st = 4, survey.effect = FALSE, strata.time.effect = FALSE,
  hyper = c("pc", "gamma")[1], pc.u = 1, pc.alpha = 0.01,
  pc.u.phi = 0.5, pc.alpha.phi = 2/3, pc.u.cor = 0.7,
  pc.alpha.cor = 0.9, pc.st.u = NA, pc.st.alpha = NA,
  pc.st.slope.u = NA, pc.st.slope.alpha = NA, overdisp.mean = 0,
  overdisp.prec = 0.4, options = list(config = TRUE),
  control.inla = list(strategy = "adaptive", int.strategy = "auto"),
  verbose = FALSE, geo = NULL, rw = NULL, ar = NULL,
  st.rw = NULL, ...)
}
\arguments{
\item{data}{count data of person-months with the following columns
\itemize{
 \item cluster: cluster ID
 \item years: time period
 \item region: region of the cluster
\item strata: stratum of the cluster
\item age: age group corresponding to the row
\item total: total number of person-month in this age group, stratum, cluster, and period
\item Y: total number of deaths in this age group, stratum, cluster, and period
}}

\item{family}{family of the model. This can be either binomial (with logistic normal prior), betabiniomial.}

\item{age.groups}{a character vector of age groups in increasing order.}

\item{age.n}{number of months in each age groups in the same order.}

\item{age.rw.group}{vector indicating grouping of the ages groups. For example, if each age group is assigned a different random walk component, then set age.rw.group to c(1:length(age.groups)); if all age groups share the same random walk component, then set age.rw.group to a rep(1, length(age.groups)). The default for 6 age groups is c(1,2,3,3,3,3), which assigns a separate random walk to the first two groups and a common random walk for the rest of the age groups. The vector should contain values starting from 1.}

\item{time.model}{Model for the main temporal trend, can be rw1, rw2, or ar1. ar1 is not implemented for yearly model with period data input. Default to be rw2. For ar1 main effect, a linear slope is also added with time scaled to be between -0.5 to 0.5, i.e., the slope coefficient represents the total change between the first year and the last year in the projection period on the logit scale.}

\item{st.time.model}{Temporal component model for the interaction term, can be rw1, rw2, or ar1. ar1 is not implemented for yearly model with period data input. Default to be the same as time.model unless specified otherwise. For ar1 interaction model, region-specific random slopes can be added by specifying \code{pc.st.slope.u} and \code{pc.st.slope.alpha}.}

\item{Amat}{Adjacency matrix for the regions}

\item{bias.adj}{the ratio of unadjusted mortality rates or age-group-specific hazards to the true rates or hazards. It needs to be a data frame that can be merged to thee outcome, i.e., with the same column names for time periods (for national adjustment), or time periods and region (for subnational adjustment). The column specifying the adjustment ratio should be named "ratio".}

\item{bias.adj.by}{vector of the column names specifying how to merge the bias adjustment to the count data. For example, if bias adjustment factor is provided in bias.adj for each region and time, then bias.adj.by should be `c("region", "time")`.}

\item{formula}{INLA formula.  See vignette for example of using customized formula.}

\item{year_label}{string vector of year names}

\item{type.st}{type for space-time interaction}

\item{survey.effect}{logical indicator whether to include a survey iid random effect. If this is set to TRUE, there needs to be a column named 'survey' in the input data frame. In prediction, this random effect term will be set to 0.}

\item{strata.time.effect}{logical indicator whether to include strata specific temporal trends.}

\item{hyper}{which hyperpriors to use. Default to be using the PC prior ("pc").}

\item{pc.u}{hyperparameter U for the PC prior on precisions.}

\item{pc.alpha}{hyperparameter alpha for the PC prior on precisions.}

\item{pc.u.phi}{hyperparameter U for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.alpha.phi}{hyperparameter alpha for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.u.cor}{hyperparameter U for the PC prior on the autocorrelation parameter in the AR prior, i.e. Prob(cor > pc.u.cor) = pc.alpha.cor.}

\item{pc.alpha.cor}{hyperparameter alpha for the PC prior on the autocorrelation parameter in the AR prior.}

\item{pc.st.u}{hyperparameter U for the PC prior on precisions for the interaction term.}

\item{pc.st.alpha}{hyperparameter alpha for the PC prior on precisions for the interaction term.}

\item{pc.st.slope.u}{hyperparameter U for the PC prior on precisions for the area-level random slope. If both pc.st.slope.u and pc.st.slope.alpha are not NA, an area-level random slope with iid prior will be added to the model. The parameterization of the random slope is so that Prob(|beta| > pc.st.slope.u) = pc.st.slope.alpha, where time covariate is rescaled to be -0.5 to 0.5, so that the random slope can be interpreted as the total deviation from the main trend from the first year to the last year to be projected, on the logit scale.}

\item{pc.st.slope.alpha}{hyperparameter alpha for the PC prior on precisions for the area-level random slope. See above for the parameterization.}

\item{overdisp.mean}{hyperparameter for the betabinomial likelihood. Mean of the over-dispersion parameter on the logit scale.}

\item{overdisp.prec}{hyperparameter for the betabinomial likelihood. Precision of the over-dispersion parameter on the logit scale.}

\item{options}{list of options to be passed to control.compute() in the inla() function.}

\item{control.inla}{list of options to be passed to control.inla() in the inla() function. Default to the "adaptive" integration strategy.}

\item{verbose}{logical indicator to print out detailed inla() intermediate steps.}

\item{geo}{Deprecated. Spatial polygon file, legacy parameter from previous versions of the package.}

\item{rw}{Deprecated. Take values 0, 1 or 2, indicating the order of random walk. If rw = 0, the autoregressive process is used instead of the random walk in the main trend. See the description of the argument ar for details.}

\item{ar}{Deprecated. Order of the autoregressive component. If ar is specified to be positive integer, the random walk components will be replaced by AR(p) terms in the interaction part. The main temporal trend remains to be random walk of order rw unless rw = 0.}

\item{st.rw}{Deprecated. Take values 1 or 2, indicating the order of random walk for the interaction term. If not specified, it will take the same order as the argument rw in the main effect. Notice that this argument is only used if ar is set to 0.}

\item{...}{arguments to be passed to the inla() function call.}
}
\value{
INLA model fit using the provided formula, country summary data, and geographic data
}
\description{
The function \code{smoothCluster} replace the previous function name \code{fitINLA2} (before version 1.0.0).
}
\examples{
\dontrun{
library(dplyr)
data(DemoData)
# Create dataset of counts
counts.all <- NULL
for(i in 1:length(DemoData)){
  counts <- getCounts(DemoData[[i]][, c("clustid", "time", "age", "died",
                                        "region", "strata")],
            variables = 'died', by = c("age", "clustid", "region", 
                                         "time", "strata"))
  counts <- counts \%>\% mutate(cluster = clustid, years = time, Y=died)
  counts$strata <- gsub(".*\\\\.","",counts$strata)
  counts$survey <- names(DemoData)[i] 
  counts.all <- rbind(counts.all, counts)
}

# fit cluster-level model on the periods
periods <- levels(DemoData[[1]]$time)
fit <- smoothCluster(data = counts.all, 
      Amat = DemoMap$Amat, 
      time.model = "rw2", 
      st.time.model = "rw1",
      strata.time.effect =  TRUE, 
      survey.effect = TRUE,
      family = "betabinomial",
      year_label = c(periods, "15-19"))
est <- getSmoothed(fit, nsim = 1000)
plot(est$stratified, plot.CI=TRUE) + ggplot2::facet_wrap(~strata) 
}

}
\seealso{
\code{\link{getDirect}}
}
\author{
Zehang Richard Li
}
