% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress_prob.R
\name{stress_prob}
\alias{stress_prob}
\title{Stressing Intervals}
\usage{
stress_prob(x, prob, lower = NULL, upper, k = 1)
}
\arguments{
\item{x}{A vector, matrix or data frame 
containing realisations of random variables. Columns of \code{x} 
correspond to random variables; OR\cr
A \code{SWIM} object, where \code{x} corresponds to the 
underlying data of the \code{SWIM} object.}

\item{prob}{Numeric vector, stressed probabilities corresponding to
the intervals defined through \code{lower} and 
\code{upper}.}

\item{lower}{Numeric vector, left endpoints of the intervals.}

\item{upper}{Numeric vector, right endpoints of the intervals.}

\item{k}{Numeric, the column of \code{x} that is stressed
\code{(default = 1)}.}
}
\value{
A \code{SWIM} object containing:
    \itemize{
      \item \code{x}, a data.frame containing the data;
      \item \code{new_weights}, a list of functions, that applied to the
    \code{k}th column of \code{x}, generate the vectors of scenario
    weights. Each component corresponds to a different stress;
    \item \code{type = "prob"};
    \item \code{specs}, a list, each component corresponds to 
    a different stress and contains \code{k}, \code{lower},  
    \code{upper} and \code{prob}. 
    }
    See \code{\link{SWIM}} for details.
}
\description{
Provides weights on simulated scenarios from a baseline stochastic
    model, such that a stressed model component (random variable) 
    fulfils constraints on probability of disjoint intervals. Scenario 
    weights are selected by constrained minimisation of the 
    relative entropy to the baseline model.
}
\details{
The intervals are treated as half open intervals, that is
    the lower endpoint are not included, whereas the upper endpoint 
    are included. If \code{upper = NULL}, the intervals 
    are consecutive and \code{prob} cumulative.\cr
    The intervals defined through \code{lower} and \code{upper} must
    be disjoint.
}
\examples{
set.seed(0)
x <- rnorm(1000)
## consecutive intervals
res1 <- stress(type = "prob", x = x, prob = 0.008, upper = -2.4)
# probability under the stressed model
cdf(res1, xCol = 1)(-2.4)

## calling stress_prob directly
## multiple intervals
res2 <- stress_prob(x = x, prob = c(0.008, 0.06), 
  lower = c(-3, -2), upper = c(-2.4, -1.6))
# probability under the stressed model
cdf(res2, xCol = 1)(c(-2.4, -1.6)) - cdf(res2, xCol = 1)(c(-3, -2))

}
\references{
\insertRef{Pesenti2019reverse}{SWIM}\cr

    \insertRef{Csiszar1975}{SWIM}
}
\seealso{
Other stress functions: \code{\link{stress_VaR_ES}},
  \code{\link{stress_VaR}}, \code{\link{stress_mean_sd}},
  \code{\link{stress_mean}}, \code{\link{stress_moment}},
  \code{\link{stress_user}}, \code{\link{stress}}
}
\author{
Silvana M. Pesenti
}
\concept{stress functions}
