% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_sql.R
\name{df_to_sql}
\alias{df_to_sql}
\title{DataFrame to SQL; Write your DataFrame or Tibble directly to SQL from R}
\usage{
df_to_sql(dataframe, driver, server, database, sql_table_name, ...)
}
\arguments{
\item{dataframe}{A DataFrame or Tibble ie PopHealthData}

\item{driver}{A driver for database ie "SQL Server"}

\item{server}{The unique name of your database server}

\item{database}{The name of the database to which you will write `dataframe`}

\item{sql_table_name}{The name that `dataframe` will be referred to in SQL database}

\item{...}{Function forwarding for additional functionality}
}
\value{
A DataFrame or Tibble written to a SQL database of your choice
}
\description{
DataFrame to SQL; Write your DataFrame or Tibble directly to SQL from R
}
\examples{
\dontrun{
library(odbc)
library(DBI)
health_data <- SangerTools::PopHealthData
df_to_sql(dataframe = health_data,
            driver  = "SQL SERVER",
           database = "DATABASE",
     sql_table_name = "New Table Name")
}
}
