% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{electoralTool}
\alias{electoralTool}
\title{A Toolkit to analyze electoral data
\code{electoralTool} can be used to analyze both aggregate data and individual voting data.}
\usage{
electoralTool(party, district, seats, polar, time, blocks, verbose = TRUE)
}
\arguments{
\item{party}{identifies the variable containing party labels. It should be used only when response variable is a frequency variable containing number of votes at the aggregate level.}

\item{district}{identifies districts. It is required when there are more than one district.}

\item{seats}{this option can be used to tell the program the number of seats by party. If used, the program will compute proportionality and parliamentary fragmentation.}

\item{polar}{identifies variables to compute polarization among groups, such as polarization by ideology. Up to five variables are allowed. If you use more than one variable, polarization will be computed using averaged polarization over the whole set of variables. Absolute and Euclidean measures of polarization are reported.}

\item{time}{tells the program that the data contains more than one election. This option identifies the date of the election or the order in which elections take place. Using this option means that the program will compute electoral and parliamentary volatitlity between elections.}

\item{blocks}{tells the program that parties are grouped into blocks to compute inter and intra blocks volatility. You can only use it if you set time(varname) previously. If you are using time(varname), but do not set blocks(varname), all the parties are suppossed to belong to the same block. Then, inter-blocks volatility will be equal to 0, and intra-blocks volatility will be equal to total volatility.}

\item{verbose}{if \code{verbose=TRUE}, tells the program to print the output.}
}
\description{
A Toolkit to analyze electoral data
\code{electoralTool} can be used to analyze both aggregate data and individual voting data.
}

