% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{fillin}
\alias{fillin}
\title{Make a data.frame Rectangular by filling missing records}
\usage{
fillin(x, by, fill = NA)
}
\arguments{
\item{x}{a data frame.}

\item{by}{a vector of at least 2 variables from the data frame. If missing all variables in the data frame will be used.}

\item{fill}{the value used to fill in, default is \code{fill = 0}.}
}
\value{
a data object of the same class as \code{x}.
}
\description{
This function produces a complete rectangularization by adding observations with missing data so that all combinations (interactions) of the specified variables exist.
}
\examples{
data <- data.frame(sex=c("female","male","male"),
race = c("black","black","white"), y = c(.5,.4,.1), x = c(32,40,53))

fillin(data, by=c(sex,race))

fillin(data, by=c(sex,race), fill=0)
}

