% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lrtest}
\alias{lrtest}
\title{Likelihood Ratio Test (LRT)}
\usage{
lrtest(model1, model2)
}
\arguments{
\item{model1}{the first model object.}

\item{model2}{the second model object.}
}
\description{
Computes the likelihood ratio test (LRT)--a goodness-of-fit--between two nested models. It checks the difference in the deviance (-2*logLikelihood) between the two candidate models against the change in degrees of freedom using a chi-squared test.
}
\details{
\verb{LR = -2 ln(L(m1)/L(m2)) = 2(ll(m2)-ll(m1))}
}
\examples{
data(titanic)
mod0 <- glm( SURVIVED ~ CLASS, family=binomial, data=titanic)
mod1 <- glm( SURVIVED ~ CLASS + SEX, family=binomial, data=titanic)

lrtest(mod0, mod1)
}

