% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{stukel}
\alias{stukel}
\title{Stukel's test of the logistic link}
\usage{
stukel(object, alternative = c("both", "alpha1", "alpha2"))
}
\arguments{
\item{object}{an object of class \code{glm}.}

\item{alternative}{add both \code{z1} and \code{z2} to model or just one of them.}
}
\description{
The Stukel's test is an alternative to the goodness-of-fit test for logistic regression.
 It tests if significant change occurs in the model with the addition of new coefficients.
}
\details{
Two new covariates, z1 and z2 are generated such that \deqn{z1 = 0.5 \* logit^{2} * I(pi >= 0.5)}, \deqn{z2 = - 0.5 \* logit^{2} \* I(pi <= 0.5)}, where \deqn{I(arg) = 1} if arg is \code{TRUE} and \deqn{I(arg) = 1} if \code{FALSE}.
}
\note{
Adapted from program published by Brett Presnell's code available at the Florida University.
}
\references{
Stukel, T.A. (1988) Generalized logistic models. \emph{Journal of the American Statistical Association} 83: 426-431.

Hosmer, David W., et al (1997) A comparison of goodness-of-fit tests for the logistic regression model. \emph{Statistics in medicine} 16.9, 965-980.

Allison, Paul (2014) \emph{Another Goodness-of-Fit Test for Logistic Regression}.
}

