% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/agostino.R
\name{agostino}
\alias{agostino}
\title{D'Agostino test of skewness}
\usage{
agostino(x, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{x}{A numeric vector of data values.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of '"two.sided"' (default), '"greater"' or '"less"'.
 You can specify just the initial letter.}
}
\description{
Performs the D'Agostino test for skewness in normally distributed data.
}
\details{
Under the hypothesis of normality, data should be symmetrical (i.e. skewness should be equal to zero).
 This test has such null hypothesis and is useful to detect a significant skewness in normally distributed data.
}
\examples{
set.seed(1234)
x = rnorm(1000)
skewness(x)
agostino(x)
}
\references{
D'Agostino, R.B. (1970). Transformation to Normality of the Null Distribution of G1. Biometrika, 57, 3, 679-681.
}

