% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SAMPLING.R
\name{samplePower}
\alias{samplePower}
\title{Calculate and plot power of a sample}
\usage{
samplePower(mu0 = 0, mu1 = 0, sigma = 1, n = 100, alpha = 0.05)
}
\arguments{
\item{mu0}{This should be the "known" mean value for your population.}

\item{mu1}{This should be the "expected" mean value from your sample. The delta between mu(0) and mu(1) is what you should consider a significant difference for the test.}

\item{sigma}{This should be the known sigma (standard deviation) for the population.}

\item{n}{The sample size.}

\item{alpha}{This is the significance level, default is alpha(twosided) = .05.}
}
\value{
\code{n} the sample size;
\code{sigma} the standard deviation;
\code{SE} the standard error of the mean;
\code{mu0} the mean of H_{0} in the population;
\code{mu1} the sample mean;
\code{mean.crit} the critical value of sample mean to achieve significance;
\code{ES} the population "effect" size gamma;
\code{delta} the effect size delta (Cohen);
\code{alpha} the significance level alpha (twosided);
\code{power} the power (1-beta).
}
\description{
Calculates and plots power of a sample z-test of a sample mean mu1
 against a population mean \code{mu0} (H_{0}: mu0 = mu1, H_{1}: mu0 <> mu1).
}
\details{
\code{sample.power} calculates the power of a one-sample z-test (twosided)
and plots the density distributions under the assumption of of H_{0}: m = mu0 and
H_{1}: m = mu1. The rejection regions of H_{0} (alpha) are colored blue, while the rejection region of H_{1} (beta) is colored red.
}
\examples{
samplePower(mu0=68, mu1=69, sigma=3.1, n=100)
## gives a power of .90
}

