% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{similarity}
\alias{similarity}
\title{Measures of Similarity}
\usage{
similarity(data, method = c("angular", "cosine", "euclid", "faith",
  "jaccard", "phi", "rr"))
}
\arguments{
\item{data}{Matrix or data frame.
A binarized dataset of verbal fluency or linguistic data}

\item{method}{Character.
Type of similarity measure to compute.

Below are the definitions for each bin:


\tabular{llll}{
\tab a \tab b \tab a+b (R1)\cr
\tab c \tab d  \tab c+d (R2)\cr
\tab a+c (C1) \tab b+d (C2) \tab a+b+c+d (N)\cr
}
    
Options include:

\itemize{

\item{\code{"angular"} =}
{\eqn{1 - (2 * acos(cosine similarity) / \pi)}}

\item{\code{"cosine"} =}
{\eqn{a / \sqrt{(a + b)(a + c)}}}

\item{\code{"faith"} =}
{\eqn{a + 0.5d / a + b + c + d}}

\item{\code{"jaccard"} =}
{\eqn{a / a + b + c}}

\item{\code{"phi"} =}
{\eqn{ad - bc / \sqrt(R1 x R2 x C1 x C2)}}

\item{\code{"rr"} =}
{\eqn{a / a + b + c + d}}

}}
}
\value{
A symmetric similarity matrix
}
\description{
Computes several measures of similarity
(see Choi, Cha, & Tappert, 2010 for additional measures)
}
\examples{
# Simulate Datasets
one <- sim.fluency(10)

# Compute similarity matrix
cos <- similarity(one, method = "cosine")

}
\references{
Choi, S. S., Cha, S. H., & Tappert, C. C. (2010).
A survey of binary similarity and distance measures.
\emph{Journal of Systemics, Cybernetics and Informatics}, \emph{8}, 43-48.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
