% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoDestr.R
\name{autoDestr}
\alias{autoDestr}
\title{Automated De-string of Responses}
\usage{
autoDestr(rmat, char = 10)
}
\arguments{
\item{rmat}{A \link[SemNetCleaner]{textcleaner} filtered response matrix}

\item{char}{Minimum number of characters in a string to be checked for \link[SemNetCleaner]{destr}.
Defaults to 10}
}
\value{
A list containing two objects:

\item{rmat}{A response matrix that has been de-stringed}

\item{string}{A list containing the responses that were de-stringed.
The row number is supplied for each case that was affected.
This can be used to replicate the de-stringing process and to keep track of changes more generally}
}
\description{
Automated de-string responses after performing textcleaner
}
\examples{
#create example stringed responses
stringed <- cbind(rowSums(cbind(rmat[,c(1,2)])),convmat)
#change name to stringed name
colnames(stringed)[1] <- "alligator.ant"

\donttest{
#text cleaned
clean <- textcleaner(rmat)

#automated de-string
convmat <- autoDestr(clean, 10)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
