% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equate.multi.R
\name{equate.multi}
\alias{equate.multi}
\title{Equate Multiple Groups}
\usage{
equate.multi(...)
}
\arguments{
\item{...}{A list.
A list of response matrices to be equated}
}
\value{
This function returns a list containing the
equated binary response matrices in the order they were input.
The response matrices are labeled (\code{1}, \code{2}, \code{...}, \code{n})
in the order in which they are input.
}
\description{
A function to apply \code{\link[SemNetCleaner]{equate}}
to multiple response matrices
}
\examples{
#finalize rmatA
finalCmat <- finalize(convmat)

#finalize rmatB
finalRmat <- finalize(rmat)

#finalize rmatC
finalYmat <- finalize(rmat)

#equate rmatA and rmatB
eq <- equate.multi(finalCmat,finalRmat,finalYmat)

#obtain respective equated response matrices
eqCmat <- eq$dataset1
eqRmat <- eq$dataset2
eqYmat <- eq$dataset3

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
