\name{panellipse}
\alias{panellipse}

\title{Confidence ellipses around products based on panelists descriptions}

\description{Virtual panels are generated using Boostrap techniques in order to display
confidence ellipses around products.}

\usage{
panellipse(donnee,col.p,col.j,firstvar,lastvar=ncol(donnee),alpha=0.05,coord=c(1,2),scale.unit=TRUE,nbsimul=500,nbchoix=NULL,bloc=NULL,name.bloc=NULL,level.search.desc=0.5,centerbypanelist=TRUE,scalebypanelist=FALSE)
}

\arguments{
  \item{donnee}{a data frame made up of at least two qualitative variables 
  (\emph{product}, \emph{panelist}) and a set of quantitative variables (sensory descriptors)}  
  \item{col.p}{the position of the \emph{product} variable}
  \item{col.j}{the position of the \emph{panelist} variable}
  \item{firstvar}{the position of the first sensory descriptor}
  \item{lastvar}{the position of the last sensory descriptor (by default the last column of \code{donnee})}
  \item{alpha}{the confidence level of the ellipses}
  \item{coord}{a length 2 vector specifying the components to plot}
  \item{scale.unit}{boolean, if T the descriptors are scaled to unit variance}
  \item{nbsimul}{the number of simulations (corresponding to the number of virtual panels) used to compute the ellipses}
  \item{nbchoix}{the number of panelists forming a virtual panel, by default the number of panelists in the original panel}  
  \item{bloc}{the number of groups of variables when multiple factor analysis is performed (by default this parameter equals NULL and a PCA is performed)}  
  \item{name.bloc}{the names of the groups of variables when mfa is performed (if \code{bloc} differs from NULL)}  
  \item{level.search.desc}{the threshold above which a descriptor is not considered as discriminant according to AOV model \code{"descriptor=Product+Panelist"}}
  \item{centerbypanelist}{boolean, if T center the data by panelist before the construction of the axes}
  \item{scalebypanelist}{boolean, if T scale the data by panelist before the construction of the axes (by default, FALSE
  is assigned to that parameter)}
}


\details{
Panellipse, step by step:\cr
Step 1 Performs a selection of discriminating descriptors with respect to a threshold set by users \cr
Step 2 Virtual panels are generated using Boostrap techniques; the number of panels as well as their size
are set by users with the \emph{nbsimul} and \emph{nbchoix} parameters \cr
Step 3 Coordinates of the products with respect to each virtual panels are computed \cr
Step 4 Each product is then circled by its confidence ellipse generated by virtual panels and
comprising (1-alpha)*100 percent of the virtual products
}
\value{
Returns a graph of the products as well as a correlation circle of the descriptors.\cr

Returns a graph where each product is displayed with respect to a panel and to each panelist composing
the panel; products described by the panel are displayed as square, they are displayed as circle when
they are described by each panelist.\cr

Returns a graph where each product is circled by its confidence ellipse generated by virtual panels.
When a Multiple Factor Analysis is performed, returns a graph where each partial product is circled by its confidence ellipse generated by virtual panels

}

\seealso{ \code{\link{panellipse.session}}}

\references{
Husson F., Le Dien S. & Pags J.  (2005). Confidence ellipse for the sensory profiles obtained by Principal Components Analysis. \emph{Food Quality and Preference}.  16 (3), 245-250. \cr
Pags J. & Husson F. (2005). Multiple Factor Analysis with confidence ellipses: a methodology to study the relationships between sensory and instrumental data. To be published in \emph{Journal of Chemometrics}.
}
\author{Franois Husson}

\examples{
\dontrun{
## Example 1: PCA
data(chocolates)
panellipse(chocolates,col.p=4,col.j=1,firstvar=5)

## And if we consider only 12 panelists in a virtual panel, what would be the size of the ellipses
panellipse(chocolates,col.p=4,col.j=1,nbchoix=12, firstvar=5)

## And if we want the confidence ellipses around the individual descriptions
panellipse(chocolates,col.p=4,col.j=1,nbchoix=1, firstvar=5)


## Example 2: MFA
data(chocolates)
panellipse(chocolates,col.p=4,col.j=1,firstvar=5,bloc=c(6,8),name.bloc=c("G1","G2"))
}
}
\keyword{multivariate}
