% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.phi.omni.R
\name{stat.phi.omni}
\alias{stat.phi.omni}
\title{calculate the omnibus phi-divergence statistics under general correlation matrix.}
\usage{
stat.phi.omni(p, M, K0 = rep(1, 4), K1 = rep(length(M[1, ]), 4), S = c(-1,
  0, 1, 2), t = 30, onesided = FALSE)
}
\arguments{
\item{p}{- input pvalues.}

\item{M}{- correlation matrix of input statistics (of the input p-values).}

\item{K0}{- vector of search range starts (from the k0th smallest p-value).}

\item{K1}{- vector of search range ends (at the k1th smallest p-value).}

\item{S}{- vector of the phi-divergence test parameters.}

\item{t}{- numerical truncation parameter.}

\item{onesided}{- TRUE if the input p-values are one-sided.}
}
\description{
calculate the omnibus phi-divergence statistics under general correlation matrix.
}
\examples{
M = toeplitz(1/(1:10)*(-1)^(0:9)) #alternating polynomial decaying correlation matrix
stat.phi.omni(runif(10), M=M, K0=rep(1,4), K1=rep(5,4), S=c(-1,0,1,2))
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal Signal-Detection Methods In Finite Cases", submitted.
}
