% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utilities.R
\name{HoverLocator}
\alias{HoverLocator}
\title{Hover Locator}
\usage{
HoverLocator(plot, data.plot, features.info = NULL, dark.theme = FALSE, ...)
}
\arguments{
\item{plot}{A ggplot2 plot}

\item{data.plot}{The oridinal data that went into the ggplot2 plot}

\item{features.info}{An optional dataframe or matrix of extra information to be displayed on hover}

\item{dark.theme}{Plot using a dark theme?}

\item{...}{Extra parameters to be passed to plotly::layout}
}
\description{
Get quick information from a scatterplot by hovering over points
}
\examples{
\dontrun{
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
HoverLocator(plot = p, data.plot = df)
}

}
\seealso{
\code{plotly::layout}

\code{ggplot2::ggplot_build}
}
