% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{DotPlotOld}
\alias{DotPlotOld}
\title{Old Dot plot visualization (pre-ggplot implementation)
Intuitive way of visualizing how gene expression changes across different identity classes (clusters).
The size of the dot encodes the percentage of cells within a class, while the color encodes the
AverageExpression level of 'expressing' cells (green is high).}
\usage{
DotPlotOld(object, genes.plot, cex.use = 2, cols.use = NULL,
  thresh.col = 2.5, dot.min = 0.05, group.by = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{genes.plot}{Input vector of genes}

\item{cex.use}{Scaling factor for the dots (scales all dot sizes)}

\item{cols.use}{colors to plot}

\item{thresh.col}{The raw data value which corresponds to a red dot (lowest expression)}

\item{dot.min}{The fraction of cells at which to draw the smallest dot (default is 0.05)}

\item{group.by}{Factor to group the cells by}
}
\value{
Only graphical output
}
\description{
Old Dot plot visualization (pre-ggplot implementation)
Intuitive way of visualizing how gene expression changes across different identity classes (clusters).
The size of the dot encodes the percentage of cells within a class, while the color encodes the
AverageExpression level of 'expressing' cells (green is high).
}
\examples{
cd_genes <- c("CD247", "CD3E", "CD9")
DotPlotOld(object = pbmc_small, genes.plot = cd_genes)

}
