% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{SetIdent}
\alias{SetIdent}
\title{Set identity class information}
\usage{
SetIdent(object, cells.use = NULL, ident.use = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{cells.use}{Vector of cells to set identity class info for (default is
all cells)}

\item{ident.use}{Vector of identity class values to assign (character
vector)}
}
\value{
A Seurat object where object@ident has been appropriately modified
}
\description{
Sets the identity class value for a subset (or all) cells
}
\examples{
cluster2 <- WhichCells(object = pbmc_small, ident = 2)
pbmc_small@ident[cluster2]
pbmc_small <- SetIdent(
  object = pbmc_small,
  cells.use = cluster2,
  ident.use = 'cluster_2'
)
pbmc_small@ident[cluster2]

}
