% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley_interaction.R
\name{shapley_interaction}
\alias{shapley_interaction}
\title{Decomposition of squared Mahalanobis distance using Shapley interaction indices.}
\usage{
shapley_interaction(x, mu, Sigma, inverted = FALSE)
}
\arguments{
\item{x}{Data vector with \eqn{p} entries containing only numeric entries.}

\item{mu}{Either \code{NULL} (default) or mean vector of \code{x}. If NULL, \code{method} is used for parameter estimation.}

\item{Sigma}{Either \code{NULL} (default) or covariance matrix \eqn{p \times p} of \code{x}. If NULL, \code{method} is used for parameter estimation.}

\item{inverted}{Logical. If \code{TRUE}, \code{Sigma} is supposed to contain the inverse of the covariance matrix.}
}
\value{
A \eqn{p \times p} matrix containing the decomposition of the squared Mahalanobis distance of \code{x}
into outlyingness scores for pairs of variables with respect to \code{mu} and \code{Sigma}.
}
\description{
The \code{shapley_interaction} function computes a \eqn{p \times p} matrix
containing pairwise outlyingness scores based on Shapley interaction indices.
It decomposes the squared Mahalanobis distance of \code{x} (with respect to \code{mu} and \code{Sigma})
into outlyingness contributions of pairs of variables \insertCite{Mayrhofer2022}{ShapleyOutlier}.
}
\examples{
p <- 5
mu <- rep(0,p)
Sigma <- matrix(0.9, p, p); diag(Sigma) = 1
Sigma_inv <- solve(Sigma)
x <- c(0,1,2,2.3,2.5)
shapley_interaction(x, mu, Sigma)
PHI <- shapley_interaction(x, mu, Sigma_inv, inverted = TRUE)
plot(PHI)
}
\references{
\insertRef{Mayrhofer2022}{ShapleyOutlier}
}
