% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.r
\name{predint}
\alias{predint}
\title{prediction interval for Sharpe ratio}
\usage{
predint(x,oosdf,oosrescal=1/sqrt(oosdf+1),ope=NULL,level=0.95,
			 level.lo=(1-level)/2,level.hi=1-level.lo)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values, or an
object of class \code{sr}.}

\item{oosdf}{the future (or 'out of sample', thus 'oos') degrees of freedom.
In the vanilla Sharpe case, this is the number of future observations
\emph{minus one}.}

\item{oosrescal}{the rescaling parameter for the future Sharpe ratio. The default value
holds for the case of unattributed models ('vanilla Shape'), but can be set
to some other value to deal with the magnitude of attribution factors in the
future period.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized' 
units for some epoch, that is, 'per square root epoch', though returns 
are observed at a frequency of \code{ope} per epoch. 
The default value is to take the same \code{ope} from the input \code{x}
object, if it is unambiguous.}

\item{level}{the confidence level required.}

\item{level.lo}{the lower confidence level required.}

\item{level.hi}{the upper confidence level required.}
}
\value{
A matrix (or vector) with columns giving lower and upper
confidence limits for the parameter. These will be labelled as
level.lo and level.hi in \%, \emph{e.g.} \code{"2.5 \%"}
}
\description{
Computes the prediction interval for Sharpe ratio.
}
\details{
Given \eqn{n_0}{n_0} observations \eqn{x_i}{xi} from a normal random variable,
with mean \eqn{\mu}{mu} and standard deviation \eqn{\sigma}{sigma}, computes
an interval \eqn{[y_1,y_2]}{[y_1,y_2]} such that with a fixed probability,
the sample Sharpe ratio over \eqn{n}{n} future observations will fall in the
given interval. The coverage is over repeated draws of both the past and
future data, thus this computation takes into account error in both the
estimate of Sharpe and the as yet unrealized returns.
}
\examples{

# should reject null
etc <- predint(rnorm(1000,mean=0.5,sd=0.1),oosdf=127,ope=1)
etc <- predint(matrix(rnorm(1000*5,mean=0.05),ncol=5),oosdf=63,ope=1)

# check coverage
mu <- 0.0005
sg <- 0.013
n1 <- 512
n2 <- 256
p  <- 100
x1 <- matrix(rnorm(n1*p,mean=mu,sd=sg),ncol=p)
x2 <- matrix(rnorm(n2*p,mean=mu,sd=sg),ncol=p)
sr1 <- as.sr(x1)
sr2 <- as.sr(x2)
# check coverage of prediction interval
etc1 <- predint(sr1,oosdf=n2-1,level=0.95)
is.ok <- (etc1[,1] <= sr2$sr) & (sr2$sr <= etc1[,2])
covr <- mean(is.ok)

}
\references{
Sharpe, William F. "Mutual fund performance." Journal of business (1966): 119-138.
\url{http://ideas.repec.org/a/ucp/jnlbus/v39y1965p119.html}

Pav, Steven. "Inference on the Sharpe ratio via the upsilon distribution.'
Arxiv (2015). 
\url{http://arxiv.org/abs/1505.00829}
}
\seealso{
\code{\link{confint.sr}}.

Other sr: 
\code{\link{as.sr}()},
\code{\link{confint.sr}()},
\code{\link{dsr}()},
\code{\link{is.sr}()},
\code{\link{plambdap}()},
\code{\link{power.sr_test}()},
\code{\link{print.sr}()},
\code{\link{reannualize}()},
\code{\link{se}()},
\code{\link{sr_equality_test}()},
\code{\link{sr_test}()},
\code{\link{sr_unpaired_test}()},
\code{\link{sr_vcov}()},
\code{\link{sr}},
\code{\link{summary.sr}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\concept{sr}
