% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMultinomial.R
\name{plotMultinomial}
\alias{plotMultinomial}
\title{Function for plotting category probabilities of multinomial log-linear regression model}
\usage{
plotMultinomial(x, matching, matching.name = "matching")
}
\arguments{
\item{x}{object of class \code{multinom}}

\item{matching}{numeric: vector of matching criterion used for estimation in \code{x}.}

\item{matching.name}{character: name of matching criterion used for estimation in \code{x}.}
}
\description{
Plots category probabilities functions estimated by \code{multinom()} from \code{nnet} package.
}
\examples{
# loading data
data(GMAT, GMATtest, GMATkey, package = "difNLR")

matching <- scale(apply(GMAT[, 1:20], 1, sum)) # Z-score
data <- GMATtest[, 1:20]
key <- GMATkey

# multinomial model for item 1
fit <- nnet::multinom(relevel(data[, 1], ref = paste(key[1])) ~ matching)

# plotting category probabilities
plotMultinomial(fit, matching, matching.name = "Z-score")
}
\seealso{
\code{\link[nnet]{multinom}}
}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Tomas Jurica \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
