% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMedicalgraded.R
\docType{data}
\name{dataMedicalgraded}
\alias{dataMedicalgraded}
\title{Graded dataset of admission test to medical school}
\format{
A \code{dataMedicalgraded} is a \code{data.frame} consisting of 2,392
observations on the following 102 variables.
\describe{
\item{X}{The first 100 columns represent ordinal item scores of the test. }
\item{gender}{Variable describing gender; values \code{"0"} and \code{"1"} refer to
males and females.}
\item{StudySuccess}{Criterion variable; value \code{"1"} means that student
studies standardly, \code{"0"} otherwise (e.g., leaving or interrupting studies).}
}
}
\usage{
data(dataMedicalgraded)
}
\description{
The \code{dataMedicalgraded} dataset consists of the responses
of 2,392 subjects (750 males, 1,633 females and 9 subjects without gender
specification) to multiple-choice admission test to a medical school. It
contains 100 items. Each item is graded with 0 to 4 points. Maximum of 4
points were set if all correct answers and none of incorrect answers were
selected.
}
\references{
Stuka, C., Vejrazka, M., Martinkova, P., Komenda, M., & Stepanek, L. (2016).
The use of test and item analysis for improvement of tests. Workshop held at
conference MEFANET, 2016, Brno, Czech Republic.
}
\seealso{
\code{\link{dataMedical}}, \code{\link{dataMedicaltest}},
\code{\link{dataMedicalkey}}
}
\author{
Cestmir Stuka \cr
First Faculty of Medicine, Charles University \cr

Martin Vejrazka \cr
First Faculty of Medicine, Charles University \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
\keyword{datasets}
